/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.internal.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.css.core.CSSCorePlugin;
import com.aptana.css.core.model.ElementElement;
import com.aptana.css.core.model.PropertyElement;
import com.aptana.css.core.model.PseudoClassElement;
import com.aptana.css.core.model.PseudoElementElement;
import com.aptana.css.core.model.SpecificationElement;
import com.aptana.css.core.model.UserAgentElement;
import com.aptana.css.core.model.ValueElement;
import com.aptana.index.core.MetadataReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSMetadataReader
extends MetadataReader {
    private static final String METADATA_SCHEMA_XML = "/metadata/CSSMetadataSchema.xml";
    private List<ElementElement> _elements = new LinkedList<ElementElement>();
    private ElementElement _currentElement;
    private PropertyElement _currentProperty;
    private PseudoClassElement _currentPseudoClass;
    private PseudoElementElement _currentPseudoElement;
    private ValueElement _currentValue;
    private UserAgentElement _currentUserAgent;
    private List<PropertyElement> _properties = new LinkedList<PropertyElement>();
    private List<PseudoClassElement> _pseudoClasses = new LinkedList<PseudoClassElement>();
    private List<PseudoElementElement> _pseudoElements = new LinkedList<PseudoElementElement>();

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        super.startElement(namespaceURI, localName, qualifiedName, attributes);
        switch (Element.fromString(localName)) {
            case BROWSER: {
                this.enterBrowser(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case ELEMENT: {
                this.enterElement(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case PROPERTY: {
                this.enterProperty(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case PROPERTY_REF: {
                this.enterPropertyReference(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case PSEUDO_CLASS: {
                this.enterPseudoClass(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case PSEUDO_ELEMENT: {
                this.enterPseudoElement(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case SPECIFICATION: {
                this.enterSpecification(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case VALUE: {
                this.enterValue(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case REMARKS: 
            case HINT: 
            case EXAMPLE: 
            case DESCRIPTION: {
                this.startTextBuffer(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)CSSCorePlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        switch (Element.fromString(localName)) {
            case BROWSER: {
                this.exitBrowser(namespaceURI, localName, qualifiedName);
                break;
            }
            case DESCRIPTION: {
                this.exitDescription(namespaceURI, localName, qualifiedName);
                break;
            }
            case ELEMENT: {
                this.exitElement(namespaceURI, localName, qualifiedName);
                break;
            }
            case EXAMPLE: {
                this.exitExample(namespaceURI, localName, qualifiedName);
                break;
            }
            case HINT: {
                this.exitHint(namespaceURI, localName, qualifiedName);
                break;
            }
            case PROPERTY: {
                this.exitProperty(namespaceURI, localName, qualifiedName);
                break;
            }
            case PSEUDO_CLASS: {
                this.exitPseudoClass(namespaceURI, localName, qualifiedName);
                break;
            }
            case PSEUDO_ELEMENT: {
                this.exitPseudoElement(namespaceURI, localName, qualifiedName);
                break;
            }
            case REMARKS: {
                this.exitRemarks(namespaceURI, localName, qualifiedName);
                break;
            }
            case VALUE: {
                this.exitValue(namespaceURI, localName, qualifiedName);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)CSSCorePlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
        super.endElement(namespaceURI, localName, qualifiedName);
    }

    public void enterBrowser(String ns, String name, String qname, Attributes attributes) {
        UserAgentElement userAgent = new UserAgentElement();
        userAgent.setPlatform(attributes.getValue("platform"));
        userAgent.setVersion(attributes.getValue("version"));
        userAgent.setOS(attributes.getValue("os"));
        this._currentUserAgent = userAgent;
    }

    public void enterElement(String ns, String name, String qname, Attributes attributes) {
        ElementElement element = new ElementElement();
        element.setName(attributes.getValue("name"));
        element.setDisplayName(attributes.getValue("display-name"));
        this._currentElement = element;
    }

    public void enterProperty(String ns, String name, String qname, Attributes attributes) {
        PropertyElement property = new PropertyElement();
        property.setName(attributes.getValue("name"));
        property.setType(attributes.getValue("type"));
        property.setAllowMultipleValues("true".equals(attributes.getValue("allow-multipe-values")));
        this._currentProperty = property;
    }

    public void enterPropertyReference(String ns, String name, String qname, Attributes attributes) {
        this._currentElement.addProperty(attributes.getValue("name"));
    }

    public void enterPseudoClass(String ns, String name, String qname, Attributes attributes) {
        PseudoClassElement pseudoClass = new PseudoClassElement();
        pseudoClass.setName(attributes.getValue("name"));
        this._currentPseudoClass = pseudoClass;
    }

    public void enterPseudoElement(String ns, String name, String qname, Attributes attributes) {
        PseudoElementElement pseudoElement = new PseudoElementElement();
        pseudoElement.setName(attributes.getValue("name"));
        pseudoElement.setAllowPseudoClassSyntax(Boolean.valueOf(attributes.getValue("allow-pseudo-class-syntax")));
        this._currentPseudoElement = pseudoElement;
    }

    public void enterSpecification(String ns, String name, String qname, Attributes attributes) {
        SpecificationElement specification = new SpecificationElement();
        specification.setName(attributes.getValue("name"));
        specification.setVersion(attributes.getValue("version"));
        if (this._currentProperty != null) {
            this._currentProperty.addSpecification(specification);
        } else if (this._currentPseudoClass != null) {
            this._currentPseudoClass.addSpecification(specification);
        } else if (this._currentPseudoElement != null) {
            this._currentPseudoElement.addSpecification(specification);
        }
    }

    public void enterValue(String ns, String name, String qname, Attributes attributes) {
        ValueElement value = new ValueElement();
        value.setName(attributes.getValue("name"));
        value.setDescription(attributes.getValue("description"));
        this._currentValue = value;
    }

    public void exitBrowser(String ns, String name, String qname) {
        if (this._currentValue != null) {
            this._currentValue.addUserAgent(this._currentUserAgent);
        } else if (this._currentProperty != null) {
            this._currentProperty.addUserAgent(this._currentUserAgent);
        } else if (this._currentElement != null) {
            this._currentElement.addUserAgent(this._currentUserAgent);
        } else if (this._currentPseudoClass != null) {
            this._currentPseudoClass.addUserAgent(this._currentUserAgent);
        } else if (this._currentPseudoElement != null) {
            this._currentPseudoElement.addUserAgent(this._currentUserAgent);
        }
        this._currentUserAgent = null;
    }

    public void exitDescription(String ns, String name, String qname) {
        String text = this.getText();
        if (this._currentProperty != null) {
            this._currentProperty.setDescription(this.resolveEntities(text));
        } else if (this._currentElement != null) {
            this._currentElement.setDescription(this.resolveEntities(text));
        } else if (this._currentUserAgent != null) {
            this._currentUserAgent.setDescription(this.resolveEntities(text));
        } else if (this._currentPseudoClass != null) {
            this._currentPseudoClass.setDescription(this.resolveEntities(text));
        } else if (this._currentPseudoElement != null) {
            this._currentPseudoElement.setDescription(this.resolveEntities(text));
        }
    }

    public void exitElement(String ns, String name, String qname) {
        this._elements.add(this._currentElement);
        this._currentElement = null;
    }

    public void exitExample(String ns, String name, String qname) {
        String text = this.getText();
        if (this._currentProperty != null) {
            this._currentProperty.setExample(this.resolveEntities(text));
        } else if (this._currentElement != null) {
            this._currentElement.setExample(this.resolveEntities(text));
        } else if (this._currentPseudoClass != null) {
            this._currentPseudoClass.setExample(this.resolveEntities(text));
        } else if (this._currentPseudoElement != null) {
            this._currentPseudoElement.setExample(this.resolveEntities(text));
        }
    }

    public void exitHint(String ns, String name, String qname) {
        String text = this.getText();
        if (this._currentProperty != null) {
            this._currentProperty.setHint(this.resolveEntities(text));
        } else if (this._currentElement != null) {
            this._currentElement.setDescription(this.resolveEntities(text));
        }
    }

    public void exitProperty(String ns, String name, String qname) {
        this._properties.add(this._currentProperty);
        this._currentProperty = null;
    }

    public void exitPseudoClass(String ns, String name, String qname) {
        this._pseudoClasses.add(this._currentPseudoClass);
        this._currentPseudoClass = null;
    }

    public void exitPseudoElement(String ns, String name, String qname) {
        this._pseudoElements.add(this._currentPseudoElement);
        this._currentPseudoElement = null;
    }

    public void exitRemarks(String ns, String name, String qname) {
        String text = this.getText();
        if (this._currentProperty != null) {
            this._currentProperty.setRemark(text);
        } else if (this._currentElement != null) {
            this._currentElement.setRemark(text);
        }
    }

    public void exitValue(String ns, String name, String qname) {
        if (this._currentProperty != null) {
            this._currentProperty.addValue(this._currentValue);
        } else if (this._currentPseudoClass != null) {
            this._currentPseudoClass.addValue(this._currentValue);
        }
        this._currentValue = null;
    }

    public List<ElementElement> getElements() {
        return this._elements;
    }

    public List<PropertyElement> getProperties() {
        return this._properties;
    }

    public List<PseudoClassElement> getPseudoClasses() {
        return this._pseudoClasses;
    }

    public List<PseudoElementElement> getPseudoElements() {
        return this._pseudoElements;
    }

    protected InputStream getSchemaStream() {
        try {
            return FileLocator.openStream((Bundle)CSSCorePlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)METADATA_SCHEMA_XML), (boolean)false);
        }
        catch (IOException e) {
            return ((Object)((Object)this)).getClass().getResourceAsStream(METADATA_SCHEMA_XML);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Element {
        VALUE("value"),
        SPECIFICATION("specification"),
        PSEUDO_ELEMENT("pseudo-element"),
        PSEUDO_CLASS("pseudo-class"),
        PROPERTY_REF("property-ref"),
        PROPERTY("property"),
        ELEMENT("element"),
        REMARKS("remarks"),
        HINT("hint"),
        EXAMPLE("example"),
        DESCRIPTION("description"),
        BROWSER("browser"),
        UNDEFINED(null);

        private String name;

        private Element(String name) {
            this.name = name;
        }

        private static Element fromString(String name) {
            if (name != null) {
                Element[] elementArray = Element.values();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element b = elementArray[n2];
                    if (name.equals(b.name)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return UNDEFINED;
        }
    }
}

